#ifndef ARMsclTg_h
#define ARMsclTg_h 1

// ARMusicalObject
#include "AbstrctR\AbstrctO\ARMsclbj.h"
#include "AbstrctR\AbstrctO\Tgprmter.h"
#include "AbstrctR\AbstrctO\TgPrmLst.h"
#include "AbstrctR\AbstrctO\TgprmtrS.h"
#include "AbstrctR\AbstrctO\TgprmtrF.h"
#include "kf_ilist.h"

#include <iostream.h>

#include "defines.h"

typedef KF_IPointerList<TagParameterList> ListOfTPLs;
typedef KF_IPointerList<NVstring> ListOfStrings;


class ARMusicalTag : 
	public ARMusicalObject
{

	public:
		virtual int MatchListOfTPLsWithTPL(const ListOfTPLs &ltpls,TagParameterList &tpl,
			TagParameterList **rtpl);
		// this routine creates the ListOfTPLs if it is
		// not already present ...
		virtual void  CreateListOfTPLs(
			ListOfTPLs &ltpl,ListOfStrings & lstrs);
		virtual int MatchEndTag(const char *endstr);
		void setAllowRange(int pallow);
		virtual void PrintParameters(ostream &os) const;
		virtual void PrintName(ostream &os) const;
		void setIsAuto(int isauto);
		int getIsAuto() const;
		// the association of a Tag
		// Left, Right, Don't Care, Error Left, Error Right
		// Error Left: It is associated to the left, but that
		// is an error.
		// Error Right: It is associated to the right, but that
		// is an error
		enum ASSOCIATION { LA, RA, DC, EL, ER };

		enum RANGE { NO, ONLY, RANGEDC };

		virtual RANGE getRangeSetting() const
		{
			return rangesetting;
		}
		virtual int IsStateTag(void) const
		{ return 0; }
		virtual void setError(int i = 1);
		virtual int getError() const
		{ return error; }
		int getID(void) const
		{ return id; }
		void setID(int pid) 
		{ id = pid; }
		ARMusicalTag(const TYPE_TIMEPOSITION &tp,const ARMusicalTag *copy = NULL)
		  : ARMusicalObject(tp),
		  id(-1),
		  isAuto(0),
		  rangesetting(NO),
		  error(0),
		  hasRange(0)
		{
			assoc = DC;
			color = NULL;
			dx = dy = size = NULL;
			if (copy)
			{
				if (copy->getColor())
					color = dynamic_cast<TagParameterString *>(
						copy->getColor()->getCopy());
				if (copy->getDX())
					dx = dynamic_cast<TagParameterFloat *>(
					copy->getDX()->getCopy());
				if (copy->getDY())
					dy = dynamic_cast<TagParameterFloat *>(
					copy->getDY()->getCopy());
				if (copy->getSize())
					size = dynamic_cast<TagParameterFloat *>(
					copy->getSize()->getCopy());
				rangesetting = copy->rangesetting;
				hasRange = copy->hasRange;
			}
		};
		ARMusicalTag(int pid = -1,const ARMusicalTag *copy = NULL) 
		  : 
		  id(pid),
		  rangesetting(NO) ,
		  error(0),
		  hasRange(0)
		{
			assoc = DC; // don't care ...
			isAuto = 0;
			color = NULL;
			dx = dy = size = NULL;
			if (copy)
			{
				if (copy->getColor())
					color = dynamic_cast<TagParameterString *>(
						copy->getColor()->getCopy());
				if (copy->getDX())
					dx = dynamic_cast<TagParameterFloat *>(
					copy->getDX()->getCopy());
				if (copy->getDY())
					dy = dynamic_cast<TagParameterFloat *>(
					copy->getDY()->getCopy());
				if (copy->getSize())
					size = dynamic_cast<TagParameterFloat *>(
					copy->getSize()->getCopy());
				rangesetting = copy->rangesetting;
				hasRange = copy->hasRange;
			}
		}
		virtual ~ARMusicalTag();

		virtual void print() const = 0;

// possibly not needed -> position is not really useful?
//		virtual POSITION getStartPosition(void) const
//			{ return pos; }
//		virtual void setStartPosition(POSITION p_pos);

		// this can be used, to see, wether the tag has a range
		virtual void setRange(int p)
		{
			if (p && (IsStateTag() || rangesetting == NO ))
			{
				// WARNING ..., State tags do not get
				// ranges ... are ignored!
			}
			
			// They have to be set anyway, so the
			// the parser can deal with closing
			// Ranges correctly!
			hasRange = p;
		} 
		virtual int getRange(void) const
		{
			return hasRange;
		}


		void setAssociation(ASSOCIATION p_assoc)
		{
			assoc = p_assoc;
		}

		ASSOCIATION getAssociation()
		{
			return assoc;
		}

		virtual ostream & operator<<(ostream &os) const;


		const TagParameterString *getColor() const
		{ return color; }

		void setColor(const char *cp) 
		{
			if (color)
				delete color;
			color = new TagParameterString(cp);
		}
		const TagParameterFloat *getDX() const
		{ return dx; }
		virtual void setDX(TagParameterFloat *tpf)
		{
			if (dx) delete dx;
			dx = tpf;
		}

		const TagParameterFloat *getDY() const
		{ return dy;}
		virtual void setDY(TagParameterFloat *tpf)
		{
			if (dy) delete dy;
			dy = tpf;
		}
		const TagParameterFloat *getSize() const
		{ return size; }
		void setSize(float newsize)
		{
			if (size)
				size->setValue(newsize);
			else
				size = new TagParameterFloat(newsize);
			
		}


  protected:
	  int id;
	  int isAuto;
	  ASSOCIATION assoc;

	  // this is the RANGE setting
	  // -> NO Range, ONLY Range or DC Range
	  // meaning:
	  // No Range: The Tag must not have a range
	  // ONLY Range: The Tag must have a range
	  // DC Range: The Tag can either have or not have
	  //    a range
	  RANGE rangesetting;
	  
	  int error;
	  
	  // not useful?
	  // POSITION pos; // fuer die Bereichstags ...

	  // is 1, if the Tag has a valid range
	  // 0 otherwise.
	  int hasRange;

	  // these are the Tagparameters 
	  // that can be optionally supplied-
	  TagParameterString *color;
	  TagParameterFloat *dx;
	  TagParameterFloat *dy;
	  TagParameterFloat *size;

};

// Class ARMusicalTag

#endif


